<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Proxy\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ServiceOptions {
	/**
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 *
	 * @return CreateServiceOptions Options builder
	 */
	public static function create( $defaultTtl = Values::NONE, $callbackUrl = Values::NONE, $geoMatchLevel = Values::NONE, $numberSelectionBehavior = Values::NONE, $interceptCallbackUrl = Values::NONE, $outOfSessionCallbackUrl = Values::NONE, $chatInstanceSid = Values::NONE ) {
		return new CreateServiceOptions( $defaultTtl, $callbackUrl, $geoMatchLevel, $numberSelectionBehavior, $interceptCallbackUrl, $outOfSessionCallbackUrl, $chatInstanceSid );
	}

	/**
	 * @param string $uniqueName A human-readable description of this resource.
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 *
	 * @return UpdateServiceOptions Options builder
	 */
	public static function update( $uniqueName = Values::NONE, $defaultTtl = Values::NONE, $callbackUrl = Values::NONE, $geoMatchLevel = Values::NONE, $numberSelectionBehavior = Values::NONE, $interceptCallbackUrl = Values::NONE, $outOfSessionCallbackUrl = Values::NONE, $chatInstanceSid = Values::NONE ) {
		return new UpdateServiceOptions( $uniqueName, $defaultTtl, $callbackUrl, $geoMatchLevel, $numberSelectionBehavior, $interceptCallbackUrl, $outOfSessionCallbackUrl, $chatInstanceSid );
	}
}

class CreateServiceOptions extends Options {
	/**
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 */
	public function __construct( $defaultTtl = Values::NONE, $callbackUrl = Values::NONE, $geoMatchLevel = Values::NONE, $numberSelectionBehavior = Values::NONE, $interceptCallbackUrl = Values::NONE, $outOfSessionCallbackUrl = Values::NONE, $chatInstanceSid = Values::NONE ) {
		$this->options['defaultTtl']              = $defaultTtl;
		$this->options['callbackUrl']             = $callbackUrl;
		$this->options['geoMatchLevel']           = $geoMatchLevel;
		$this->options['numberSelectionBehavior'] = $numberSelectionBehavior;
		$this->options['interceptCallbackUrl']    = $interceptCallbackUrl;
		$this->options['outOfSessionCallbackUrl'] = $outOfSessionCallbackUrl;
		$this->options['chatInstanceSid']         = $chatInstanceSid;
	}

	/**
	 * The default time delay in seconds after the latest of Session create time or the Session's last Interaction time, after which a session will expire.  Used for sessions where TTL is not specified.
	 *
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 *
	 * @return $this Fluent Builder
	 */
	public function setDefaultTtl( $defaultTtl ) {
		$this->options['defaultTtl'] = $defaultTtl;

		return $this;
	}

	/**
	 * The URL to which Twilio will make callbacks on interaction status changes.
	 *
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 *
	 * @return $this Fluent Builder
	 */
	public function setCallbackUrl( $callbackUrl ) {
		$this->options['callbackUrl'] = $callbackUrl;

		return $this;
	}

	/**
	 * Whether proxy number selected must be in the same area code as the participant identifier. Options: `country`, `area-code`, `extended-area-code`. Default: `country`. Levels lower than country are only available in North America.
	 *
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 *
	 * @return $this Fluent Builder
	 */
	public function setGeoMatchLevel( $geoMatchLevel ) {
		$this->options['geoMatchLevel'] = $geoMatchLevel;

		return $this;
	}

	/**
	 * Options: `prefer-sticky`, `avoid-sticky`. Default: `prefer-sticky`.
	 *
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 *
	 * @return $this Fluent Builder
	 */
	public function setNumberSelectionBehavior( $numberSelectionBehavior ) {
		$this->options['numberSelectionBehavior'] = $numberSelectionBehavior;

		return $this;
	}

	/**
	 * A URL for Twilio call before each Interaction. Returning a 403 status code will prevent the interaction from continuing.
	 *
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 *
	 * @return $this Fluent Builder
	 */
	public function setInterceptCallbackUrl( $interceptCallbackUrl ) {
		$this->options['interceptCallbackUrl'] = $interceptCallbackUrl;

		return $this;
	}

	/**
	 * A URL for Twilio call when a new Interaction has no [Session](https://www.twilio.com/docs/proxy/api/session). See [Out-of-Session Callback Response Guide](https://www.twilio.com/docs/proxy/out-session-callback-response-guide) for more information.
	 *
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 *
	 * @return $this Fluent Builder
	 */
	public function setOutOfSessionCallbackUrl( $outOfSessionCallbackUrl ) {
		$this->options['outOfSessionCallbackUrl'] = $outOfSessionCallbackUrl;

		return $this;
	}

	/**
	 * The Chat Service Instance sid managed by Proxy Service. Enables Proxy to forward sms and channel messages to this chat instance. This is a one-to-one relationship.
	 *
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 *
	 * @return $this Fluent Builder
	 */
	public function setChatInstanceSid( $chatInstanceSid ) {
		$this->options['chatInstanceSid'] = $chatInstanceSid;

		return $this;
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$options = array();
		foreach ( $this->options as $key => $value ) {
			if ( $value != Values::NONE ) {
				$options[] = "$key=$value";
			}
		}

		return '[Twilio.Proxy.V1.CreateServiceOptions ' . implode( ' ', $options ) . ']';
	}
}

class UpdateServiceOptions extends Options {
	/**
	 * @param string $uniqueName A human-readable description of this resource.
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 */
	public function __construct( $uniqueName = Values::NONE, $defaultTtl = Values::NONE, $callbackUrl = Values::NONE, $geoMatchLevel = Values::NONE, $numberSelectionBehavior = Values::NONE, $interceptCallbackUrl = Values::NONE, $outOfSessionCallbackUrl = Values::NONE, $chatInstanceSid = Values::NONE ) {
		$this->options['uniqueName']              = $uniqueName;
		$this->options['defaultTtl']              = $defaultTtl;
		$this->options['callbackUrl']             = $callbackUrl;
		$this->options['geoMatchLevel']           = $geoMatchLevel;
		$this->options['numberSelectionBehavior'] = $numberSelectionBehavior;
		$this->options['interceptCallbackUrl']    = $interceptCallbackUrl;
		$this->options['outOfSessionCallbackUrl'] = $outOfSessionCallbackUrl;
		$this->options['chatInstanceSid']         = $chatInstanceSid;
	}

	/**
	 * A human-readable description of this resource, up to 64 characters. *Should not contain PII.*
	 *
	 * @param string $uniqueName A human-readable description of this resource.
	 *
	 * @return $this Fluent Builder
	 */
	public function setUniqueName( $uniqueName ) {
		$this->options['uniqueName'] = $uniqueName;

		return $this;
	}

	/**
	 * The default time delay in seconds after the latest of Session create time or the Session's last Interaction time, after which a session will expire.  Used for sessions where TTL is not specified.
	 *
	 * @param integer $defaultTtl Default TTL for Sessions in Service, in seconds.
	 *
	 * @return $this Fluent Builder
	 */
	public function setDefaultTtl( $defaultTtl ) {
		$this->options['defaultTtl'] = $defaultTtl;

		return $this;
	}

	/**
	 * The URL to which Twilio will make callbacks on interaction status changes.
	 *
	 * @param string $callbackUrl URL Twilio will send callbacks to
	 *
	 * @return $this Fluent Builder
	 */
	public function setCallbackUrl( $callbackUrl ) {
		$this->options['callbackUrl'] = $callbackUrl;

		return $this;
	}

	/**
	 * Whether proxy number selected must be in the same area code as the participant identifier. Options: `country`, `area-code`, `extended-area-code`. Default: `country`. Levels lower than country are only available in North America.
	 *
	 * @param string $geoMatchLevel Whether proxy number selected must be in the
	 *                              same area code as the participant identifier.
	 *
	 * @return $this Fluent Builder
	 */
	public function setGeoMatchLevel( $geoMatchLevel ) {
		$this->options['geoMatchLevel'] = $geoMatchLevel;

		return $this;
	}

	/**
	 * Options: `prefer-sticky`, `avoid-sticky`. Default: `prefer-sticky`.
	 *
	 * @param string $numberSelectionBehavior What behavior to use when choosing a
	 *                                        proxy number.
	 *
	 * @return $this Fluent Builder
	 */
	public function setNumberSelectionBehavior( $numberSelectionBehavior ) {
		$this->options['numberSelectionBehavior'] = $numberSelectionBehavior;

		return $this;
	}

	/**
	 * A URL for Twilio call before each Interaction. Returning a 403 status code will prevent the interaction from continuing.
	 *
	 * @param string $interceptCallbackUrl A URL for Twilio call before each
	 *                                     Interaction.
	 *
	 * @return $this Fluent Builder
	 */
	public function setInterceptCallbackUrl( $interceptCallbackUrl ) {
		$this->options['interceptCallbackUrl'] = $interceptCallbackUrl;

		return $this;
	}

	/**
	 * A URL for Twilio call when a new Interaction has no [Session](https://www.twilio.com/docs/proxy/api/session). See [Out-of-Session Callback Response Guide](https://www.twilio.com/docs/proxy/out-session-callback-response-guide) for more information.
	 *
	 * @param string $outOfSessionCallbackUrl A URL for Twilio call when a new
	 *                                        Interaction has no Session.
	 *
	 * @return $this Fluent Builder
	 */
	public function setOutOfSessionCallbackUrl( $outOfSessionCallbackUrl ) {
		$this->options['outOfSessionCallbackUrl'] = $outOfSessionCallbackUrl;

		return $this;
	}

	/**
	 * The Chat Service Instance sid managed by Proxy Service. Enables Proxy to forward sms and channel messages to this chat instance. This is a one-to-one relationship.
	 *
	 * @param string $chatInstanceSid The Chat Service Instance sid managed by
	 *                                Proxy Service
	 *
	 * @return $this Fluent Builder
	 */
	public function setChatInstanceSid( $chatInstanceSid ) {
		$this->options['chatInstanceSid'] = $chatInstanceSid;

		return $this;
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$options = array();
		foreach ( $this->options as $key => $value ) {
			if ( $value != Values::NONE ) {
				$options[] = "$key=$value";
			}
		}

		return '[Twilio.Proxy.V1.UpdateServiceOptions ' . implode( ' ', $options ) . ']';
	}
}